	function [h, x] = SOLVE_LP(N, Wpb, Wsb, d1, d2, vlb, vub)
	
	% 	Linear programming design of linear-phase lowpass FIR
	% 	filter of type I or II
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Per Loewenborg 2001-10-09
	% 	Modified by: 	LW 2001-12-02, TS 2018-12-12
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1  
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% Set New = 1 and = 0 for new versiosns of MATLAB linprog and lp for older version
	
	New = 1;
	
	% Check type
	if mod(N,2) == 0   % Even order
		Ftype = 1;      % Type I
	    M = N/2+1;
		m = 1:M;
	    wt = [Wpb Wsb];
	    Kp = length(Wpb);
	    Ks = length(Wsb);
	    D = [ones(1,Kp) zeros(1,Ks)];
	    W = [ones(1,Kp)/d1 ones(1,Ks)/d2];
	    A = [TRIGMAT(Ftype,m,wt) -1./W'];
	    A = [A' [-TRIGMAT(Ftype,m,wt) -1./W']']';
	    b = [D -D]';
	    c = [zeros(1,M) 1]';
		if New == 1
			x = linprog(c,A,b,[],[],vlb,vub);
		else
			x = lp(c,A,b,vlb,vub);
		end
		h = [0.5*fliplr(x(2:M)') x(1) 0.5*x(2:M)']; 
	else  
		Ftype = 2;       % Type II - odd order
		M = (N+1)/2;
		m = 1:M;
	    wt = [Wpb Wsb];
	    Kp = length(Wpb);
	    Ks = length(Wsb);
	    D = [ones(1,Kp) zeros(1,Ks)];
	    W = [ones(1,Kp)/d1 ones(1,Ks)/d2];
	    A = [TRIGMAT(Ftype,m,wt) -1./W'];
	    A = [A' [-TRIGMAT(Ftype, m,wt) -1./W']']';
	    b = [D -D]';
	    c = [zeros(1,M) 1]';
		if New == 1
			x = linprog(c,A,b,[],[],vlb,vub);
		else
			x = lp(c,A,b,vlb,vub);
		end
		h = [0.5*fliplr(x(1:M)') 0.5*x(1:M)'];	
	end
	m = 1:M;
	wt = [Wpb Wsb];
	Kp = length(Wpb);
	Ks = length(Wsb);
	D = [ones(1,Kp) zeros(1,Ks)];
	W = [ones(1,Kp)/d1 ones(1,Ks)/d2];
	A = [TRIGMAT(Ftype, m, wt) -1./W'];
	A = [A' [-TRIGMAT(Ftype, m, wt) -1./W']']';
	b = [D -D]';
	c = [zeros(1,M) 1]';
	if New == 1
		linprog(c,A,b);
	else
		x = lp(c,A,b);
	end

